<?php 

/**
 * @package Helix Ultimate Framework
 * @author JoomShaper https://www.joomshaper.com
 * @copyright Copyright (c) 2010 - 2025 JoomShaper
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or Later
*/

defined('_JEXEC') or die;

use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Layout\LayoutHelper;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Version;

$item = $displayData;
$item->enableOpenGraph = false;
$params = $item->params;
$info = $params->get('info_block_position', 0);
$attribs = json_decode($item->attribs ?? "");
HTMLHelper::addIncludePath(JPATH_COMPONENT . '/helpers/html');
$article_format = (isset($attribs->helix_ultimate_article_format) && $attribs->helix_ultimate_article_format) ? $attribs->helix_ultimate_article_format : 'standard';

$item->heading = 'h4';

$version = new Version();
$JoomlaVersion = $version->getShortVersion();
?>
<div class="article">
    <?php if($article_format === 'gallery') : ?>
        <?php echo LayoutHelper::render('joomla.content.blog.gallery', array('attribs' => $attribs, 'id' => $item->id)); ?>
    <?php elseif($article_format === 'video') : ?>
        <?php echo LayoutHelper::render('joomla.content.blog.video', array('attribs' => $attribs)); ?>
    <?php elseif($article_format === 'audio') : ?>
        <?php echo LayoutHelper::render('joomla.content.blog.audio', array('attribs' => $attribs)); ?>
    <?php else: ?>
        <a href="<?php echo Route::_(version_compare($JoomlaVersion, '4.0.0', '>=') ? Joomla\Component\Content\Site\Helper\RouteHelper::getArticleRoute($item->slug, $item->catid, $item->language) : ContentHelperRoute::getArticleRoute($item->slug, $item->catid, $item->language)); ?>">
            <?php echo LayoutHelper::render('joomla.content.full_image', $item); ?>
        </a>
    <?php endif; ?>

    <?php echo LayoutHelper::render('joomla.content.blog_style_default_item_title', $item); ?>

    <div class="article-info">
        <?php if ($params->get('show_author') && !empty($item->author )) : ?>
            <?php echo LayoutHelper::render('joomla.content.info_block.author', array('item' => $item, 'params' => $params,'articleView'=>'intro')); ?>
        <?php endif; ?>
        <?php if ($params->get('show_publish_date')) : ?>
            <?php echo LayoutHelper::render('joomla.content.info_block.publish_date', array('item' => $item, 'params' => $params,'articleView'=>'intro')); ?>
        <?php endif; ?>
    </div>        
</div>