<?php
/**
 * @package     Joomla.Site
 * @subpackage  mod_jm_articles_category
 *
 * @copyright   Copyright (C) 2005 - 2017 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

$i = 0;
$g = 0;
$row = 0;

$items = count($list);
$carousel_class = ( $carousel == 1 && $grouped == 0 ) ? 'carousel slide carousel-fade' : '';
$carousel_in_class = ( $carousel == 1 && $grouped == 0 ) ? 'carousel-inner' : '';
$carousel_data_ride = ( $carousel == 1 && $grouped == 0 ) ? 'data-bs-ride="carousel"' : '';
$carousel_data_autoplay = ( $carousel == 1 && $grouped == 0 && $auto_play == 0 ) ? 'data-bs-interval="false"' : 'data-bs-interval="'.$interval .'"';
$item_class = ( $carousel == 1 && $grouped == 0 ) ? 'carousel-item' : '';
$active_class = ( $carousel == 1 && $grouped == 0 ) ? 'active' : '';
$indicators_class = ( $carousel == 1 && $show_indicators == 1 ) ? 'indicators' : '';

?>
<div id="<?php echo $id; ?>" class="jm-category-module clearfix <?php echo $carousel_class . ' ' . $indicators_class . ' ' . $theme_class . ' ' . $moduleclass_sfx; ?>" <?php echo $carousel_data_ride; ?> <?php echo $carousel_data_autoplay; ?>>
	<?php if ($grouped) : // groupped view ?>
		<?php foreach ($list as $group_name => $group) :
			$g++;
		?>
			<div class="jmm-group jmm-group<?php echo $g; ?>">
				<div class="jmm-rows <?php echo 'rows-' . $columns . ' ' . $carousel_in_class; ?>">
					<div class="jmm-row row-<?php echo $row . ' ' . $item_class; ?>">

						<?php foreach ($group as $item) :

						if($i % $columns == 0 && $i > 0) {
							$row++;
							echo '</div><div class="jmm-row row-' . $row . ' ' . $item_class . '">';
						}

						$i++;

						?>
						<div class="jmm-item jmm-item<?php echo $i; ?>">

							<?php
								ModJMArticlesCategoryHelper::displayItem($params, $item);
							?>

						</div>
						<?php endforeach; ?>
					</div>
				</div>
			</div>
		<?php endforeach; ?>

	<?php else : // normal view ?>
		<?php if( $carousel == 1 && $show_indicators == 1 && $grouped == 0 ) :
			$visible = ceil($items/$columns);
		?>
			
			<div class="carousel-indicators">
				<?php for($i = 0; $i < $visible; $i++ ) :
					$class = ( $i == 0 ) ? ' class="active"' : '';
					$aria_current = ( $i == 0 ) ? ' aria-current="true"' : '';
				?>
					<button type="button" data-bs-target="#<?php echo $id; ?>" data-bs-slide-to="<?php echo $i; ?>" <?php echo $class; ?> <?php echo $aria_current; ?> aria-label="Slide <?php echo $i+1; ?>"></button>
				<?php endfor; ?>
			</div>
		<?php endif; ?>
		<div class="jmm-rows <?php echo 'rows-' . $columns . ' ' . $carousel_in_class; ?>">
			<div class="jmm-row row-<?php echo $row . ' ' . $item_class . ' ' . $active_class; ?>">

				<?php $i = 0; ?>
				<?php foreach ($list as $item) :

				if($i % $columns == 0 && $i > 0) {
					$row++;
					echo '</div><div class="jmm-row row-' . $row . ' ' . $item_class . '">';
				}

				$i++;

				?>
				<div class="jmm-item jmm-item<?php echo $i; ?>">

				<?php
					ModJMArticlesCategoryHelper::displayItem($params, $item);
				?>

				</div>
				<?php endforeach; ?>
			</div>
		</div>
		<?php if( $carousel == 1 && $show_nav == 1 && $grouped == 0 ) : ?>
			<button class="carousel-control-prev" type="button" data-bs-target="#<?php echo $id; ?>" data-bs-slide="prev">
				<span class="carousel-control-prev-icon" aria-hidden="true"></span>
				<span class="visually-hidden"><?php echo JText::_('MOD_JM_ARTICLES_CATEGORY_NAV_PREV_LABEL'); ?></span>
			</button>
			<button class="carousel-control-next" type="button" data-bs-target="#<?php echo $id; ?>" data-bs-slide="next">
				<span class="carousel-control-next-icon" aria-hidden="true"></span>
				<span class="visually-hidden"><?php echo JText::_('MOD_JM_ARTICLES_CATEGORY_NAV_NEXT_LABEL'); ?></span>
			</button>
		<?php endif; ?>
	<?php endif; ?>
</div>
