<?php
/**
/**
 * @package     Joomla.Site
 * @subpackage  mod_jm_articles_category
 *
 * @copyright   Copyright (C) 2005 - 2017 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

\defined('_JEXEC') or die;

use Joomla\CMS\Language\Text;
use Joomla\CMS\Log\Log;
use Joomla\CMS\Extension\ExtensionHelper;
use Joomla\CMS\Installer\Installer;
use Joomla\CMS\Factory;

/**
 * Script file of Foo module
 */
class mod_jm_articles_categoryInstallerScript
{

	/**
	 * Extension script constructor.
	 *
	 * @return  void
	 */
	public function __construct()
	{
		$this->extension_name = 'mod_jm_articles_category';
		$this->minimumJoomla = '4.0';
	}

	/**
	 * Method to install the extension
	 *
	 * @param   InstallerAdapter  $parent  The class calling this method
	 *
	 * @return  boolean  True on success
	 */
	function install($parent)
	{

		return true;
	}

	/**
	 * Method to uninstall the extension
	 *
	 * @param   InstallerAdapter  $parent  The class calling this method
	 *
	 * @return  boolean  True on success
	 */
	function uninstall($parent)
	{

		return true;
	}

	/**
	 * Method to update the extension
	 *
	 * @param   InstallerAdapter  $parent  The class calling this method
	 *
	 * @return  boolean  True on success
	 */
	function update($parent)
	{

		return true;
	}

	/**
	 * Function called before extension installation/update/removal procedure commences
	 *
	 * @param   string            $type    The type of change (install, update or discover_install, not uninstall)
	 * @param   InstallerAdapter  $parent  The class calling this method
	 *
	 * @return  boolean  True on success
	 */
	function preflight($action, $installer)
	{
		$jversion = new JVersion();
		$module_manifest = $installer->getManifest();
		$extension_version = (string) $module_manifest->version;
		//$extension_version = '1.04';
		
		$db = Factory::getDbo();
		$query = $db->getQuery(true);
		$query->select('*')->from('#__extensions')->where('name = ' . $db->quote($this->extension_name));
		$db->setQuery($query);
		$installed_extension_data = $db->loadObject();
		if ($installed_extension_data) {
			$installed_extension_manifest = json_decode($installed_extension_data->manifest_cache);
		}

		// Check for the minimum Joomla version before continuing
		if (!empty($this->minimumJoomla) && version_compare(JVERSION, $this->minimumJoomla, '<')) {
			Log::add(Text::sprintf('JLIB_INSTALLER_MINIMUM_JOOMLA', $this->minimumJoomla), Log::WARNING, 'jerror');

			return false;
		}

		return true;
	}

	/**
	 * Function called after extension installation/update/removal procedure commences
	 *
	 * @param   string            $type    The type of change (install, update or discover_install, not uninstall)
	 * @param   InstallerAdapter  $parent  The class calling this method
	 *
	 * @return  boolean  True on success
	 */
	function postflight($type, $parent)
	{
		return true;
	}
}